
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was HpkConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(_Hpk_supported_components Core Avx2 Avx512 Sve256 Omp)

set(_Hpk_include_components ${Hpk_FIND_COMPONENTS})
if(NOT _Hpk_include_components)
    # If no components were specified by find_package(), include them all.
    list(APPEND _Hpk_include_components ${_Hpk_supported_components})
endif()

foreach(_comp ${_Hpk_include_components})
    if (NOT _comp IN_LIST _Hpk_supported_components)
        set(Hpk_FOUND False)
        set(Hpk_NOT_FOUND_MESSAGE "Unsupported component: ${_comp}")
    endif()
    if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/Hpk${_comp}Targets.cmake")
        set(Hpk_${_comp}_FOUND True)
        include("${CMAKE_CURRENT_LIST_DIR}/Hpk${_comp}Targets.cmake")
    else()
        message(STATUS "Hpk is missing component: ${_comp}")
    endif()
endforeach()

check_required_components(Hpk)
