/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
*  Copyright (C) 2023--2026, High Performance Kernels LLC                     *
*                                                                             *
*  This software and the related documents are High Performance Kernels LLC   *
*  copyrighted materials, and your use of them is governed by the express     *
*  license under which they were provided to you (License).                   *
*  Unless the License provides otherwise, you may not use, copy, reproduce,   *
*  modify, disclose, transmit, publish, or distribute this software or the    *
*  related documents without prior written permission from High Performance   *
*  Kernels LLC.                                                               *
*                                                                             *
*    This software and the related documents are provided as is, WITHOUT ANY  *
*  WARRANTY, without even the implied warranty of MERCHANTABILITY or FITNESS  *
*  FOR A PARTICULAR PURPOSE.                                                  *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <filesystem>
#include <iostream>

#include <hpk/detection.hpp>

// This code builds a multi-call binary, i.e., an executable program that
// behaves differently depending on the name of the binary itself.
// It is recommended that the binary be compiled once and three other links
// be made to that one file.   SEE ALSO: ln(1)

// Note that the resources reported are those available to the current process,
// i.e., the process's CPU affinity is respected.

int main(int argc, char* argv[]) {
    if (argc == 1) {
        auto name = std::filesystem::path(argv[0]).filename();
        if (name == std::filesystem::path("ncpu")) {
            std::cout << hpk::detectCpus() << std::endl;
            return 0;
        }
        if (name == std::filesystem::path("ncore")) {
            std::cout << hpk::detectCores() << std::endl;
            return 0;
        }
        if (name == std::filesystem::path("ndie")) {
            std::cout << hpk::detectDies() << std::endl;
            return 0;
        }
        if (name == std::filesystem::path("npkg")) {
            std::cout << hpk::detectPackages() << std::endl;
            return 0;
        }
    }
    return -1;
}
