/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
*  Copyright (C) 2023--2026, High Performance Kernels LLC                     *
*                                                                             *
*  This software and the related documents are High Performance Kernels LLC   *
*  copyrighted materials, and your use of them is governed by the express     *
*  license under which they were provided to you (License).                   *
*  Unless the License provides otherwise, you may not use, copy, reproduce,   *
*  modify, disclose, transmit, publish, or distribute this software or the    *
*  related documents without prior written permission from High Performance   *
*  Kernels LLC.                                                               *
*                                                                             *
*    This software and the related documents are provided as is, WITHOUT ANY  *
*  WARRANTY, without even the implied warranty of MERCHANTABILITY or FITNESS  *
*  FOR A PARTICULAR PURPOSE.                                                  *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <complex>
#include <iostream>
#include <vector>

#include <hpk/fft/makeFactory.hpp>

int main() {
    auto factory = hpk::fft::makeFactory<float>();
    auto fft = factory->makeInplace({4});  // Four points
    std::vector<std::complex<float>> v = {7.0f, 0.0f, 0.0f, 0.0f};
    std::cout << "Time:";
    for (const auto& point : v) std::cout << ' ' << point;
    std::cout << '\n';
    fft->forward(v.data());  // Compute the FFT!
    std::cout << "Freq:";
    for (const auto& point : v) std::cout << ' ' << point;
    std::cout << '\n';
}
